/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.vo.MosPVo;
import jp.mosp.human.dto.MKihonDto;

public class HumanListVo extends MosPVo {

	private static final long serialVersionUID = -3999859872499801119L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/human/humanList.jsp";
	private static final String EXTRA_JS   = "/pub/human/js/humanList.js";
	private static final String EXTRA_CSS  = "/pub/human/css/humanList.css";	

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_HUMAN_LIST;

	// p[^
	public static final String PRM_TXT_K_CODE 	= "txtKCode";
	public static final String PRM_TXT_K_NAME 	= "txtKName";
	public static final String PRM_PLT_OFFICE 	= "pltOffice";
	public static final String PRM_PLT_SECTION	= "pltSection";
	public static final String PRM_PLT_POSITION 	= "pltPosition";
	public static final String PRM_PLT_RETIREMENT = "pltRetirement";

	// tB[hyѐ
	public static final String NAM_K_CODE 			= CommonConst.NAM_K_CODE ;
	public static final String NAM_K_NAME 			= CommonConst.NAM_K_NAME ;
	public static final String NAM_OFFICE 			= CommonConst.NAM_OFFICE ;
	public static final String NAM_SECTION			= CommonConst.NAM_STATION;
	public static final String NAM_POSITION			= CommonConst.NAM_POSITION1;
	public static final String NAM_RETIREMENT_TYPE 	= CommonConst.NAM_RETIREMENT_TYPE;

	public static final int LEN_K_CODE    = CommonConst.LEN_K_CODE;
	public static final int LEN_K_NAME    = CommonConst.LEN_K_NAME;

	// tB[h
	private String[] aryKCode;
	private String[] aryKName;
	private String[] aryOffice;
	private String[] arySection;
	private String[] aryPosition;
	private String[] aryRetirement;
	private String   txtKCode;
	private String   txtKName;
	private String   pltOffice;
	private String   pltSection;
	private String   pltPosition;
	private String   pltRetirement;

	// v_EXg
	public String[][] aryPltOfficeAll;
	public String[][] aryPltOffice;
	public String[][] aryPltSectionAll;
	public String[][] aryPltSection;
	public String[][] aryPltPositionAll;
	public String[][] aryPltPosition;
	public String[][] aryPltRetirement;

	// \[gL[
	public final String KEY_K_CODE 		= "keyKCode";
	public final String KEY_K_NAME 		= "keyKName";
	public final String KEY_OFFICE 		= "keyOffice";
	public final String KEY_SECTION 		= "keySection";
	public final String KEY_POSITION 		= "keyPosition";
	public final String KEY_RETIREMENT 	= "keyRetirement";

	/**
	 * RXgN^
	 */
	public HumanListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtKCode 		= "";
		txtKName 		= "";
		pltOffice 		= "";
		pltSection 		= "";
		pltPosition 	= "";
		pltRetirement 	= "";
		aryKCode 		= new String[0];
		aryKName 		= new String[0];
		arySection 		= new String[0];
		aryPosition 	= new String[0];
		aryRetirement 	= new String[0];
		aryOffice 		= new String[0];
		setFormerKey(KEY_K_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode		= request.getParameter(PRM_TXT_K_CODE);
		txtKName		= request.getParameter(PRM_TXT_K_NAME);
		pltOffice		= request.getParameter(PRM_PLT_OFFICE);
		pltSection		= request.getParameter(PRM_PLT_SECTION);
		pltPosition		= request.getParameter(PRM_PLT_POSITION);
		pltRetirement	= request.getParameter(PRM_PLT_RETIREMENT);
	}

	/**
	 * tB[hݒ
	 * @param listHuman ЈXg
	 */
	public void setFields(List listHuman) {
		// Xg̐ݒ
		list = listHuman;
		// f[^̎擾
		count = listHuman.size();
		// z̏
		aryKCode		= new String[count];
		aryKName		= new String[count];
		aryOffice		= new String[count];
		arySection		= new String[count];
		aryPosition		= new String[count];
		aryRetirement	= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			aryKCode[i]   = escapeHTML(dto.getKCode());
			aryKName[i]   = escapeHTML(dto.getSimei());
			aryOffice[i] = "";
			for (int j = 0; j < aryPltOfficeAll.length; j++) {
				if (aryPltOfficeAll[j][0].equals(dto.getJCode())) {
					aryOffice[i] = escapeHTML(aryPltOfficeAll[j][1]);
					break;
				}
			}
			arySection[i] = "";
			for (int j = 0; j < aryPltSectionAll.length; j++) {
				if (aryPltSectionAll[j][0].equals(dto.getSCode())) {
					arySection[i] = escapeHTML(aryPltSectionAll[j][1]);
					break;
				}
			}
			aryPosition[i] = "";
			for (int j = 0; j < aryPltPositionAll.length; j++) {
				if (aryPltPositionAll[j][0].equals(dto.getYCode()) 
						&& aryPltPositionAll[j][2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(aryPltPositionAll[j][1]);
					break;
				}
			}
			aryRetirement[i] = "";
			for (int j = 0; j < aryPltRetirement.length; j++) {
				if (aryPltRetirement[j][0].equals(dto.getKnKubun())) {
					aryRetirement[i] = escapeHTML(aryPltRetirement[j][1]);
					break;
				}
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryKCode		() { return aryKCode.clone()		; }
	public String[] getEscAryKName		() { return aryKName.clone()		; }
	public String[] getEscArySection	() { return arySection.clone()		; }
	public String[] getEscAryPosition	() { return aryPosition.clone()		; }
	public String[] getEscAryRetirement	() { return aryRetirement.clone()	; }
	public String[] getEscAryOffice  	() { return aryOffice.clone()		; }

	public String getTxtKCode		() { return txtKCode				; }
	public String getTxtKName		() { return txtKName				; }
	public String getPltOfiice		() { return pltOffice				; }
	public String getPltSection		() { return pltSection				; }
	public String getPltPosition	() { return pltPosition				; }
	public String getPltRetirement	() { return pltRetirement			; }

	public String getEscTxtKCode	() { return escapeHTML(txtKCode); }
	public String getEscTxtKName	() { return escapeHTML(txtKName); }

	public void setPltSection		(String pltSection)		{ this.pltSection		= pltSection	; }
	public void setPltRetirement	(String pltRetirement)	{ this.pltRetirement	= pltRetirement	; }

}
